package ohd.hseb.hefs.utils.arguments;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;

import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;

import ohd.hseb.hefs.utils.plugins.GenericParameter;
import ohd.hseb.hefs.utils.plugins.UniqueGenericParameterList;

/**
 * Generic popup menu that can be used for selecting arguments or functions. The menu is constructed from an
 * ArgumentsProcessor and fires events within the ArgumentPopuupMenuListener when a menu selection is made. <br>
 * <br>
 * I have commented out interesting code below that allows for a JOptionPane to show up over a popup menu without the
 * popup menu closing. However, it did not work correctly if the popup menu was spawned from a JTable cell editor.
 * Hence, I've commented it out so that we can refer to it in the future if desired.
 * 
 * @author herrhd
 */
public class ArgumentPopupMenu extends JPopupMenu implements ActionListener
{
    private static final long serialVersionUID = 1L;

    private JComponent _parentComponentForLocatingDialogs = null;
    private final ArgumentsProcessor _argumentsProcessor;
    private final List<JMenuItem> _regularItems = new ArrayList<JMenuItem>();
    private final List<JMenuItem> _functionItems = new ArrayList<JMenuItem>();

    private final List<ArgumentPopupMenuListener> _listeners = new ArrayList<ArgumentPopupMenuListener>();

    public ArgumentPopupMenu(ArgumentsProcessor argProc)
    {
        this(argProc, true);
    }

    public ArgumentPopupMenu(ArgumentsProcessor argProc, boolean includeFunctions)
    {
        this._argumentsProcessor = argProc;

        JMenuItem item = new JMenuItem("Clear Field");
        item.addActionListener(this);
        this.add(item);

        //ARGUMENTS
        this.addSeparator();
        this.add(new JMenuItem("Select Argument:"));
        _argumentsProcessor.getPredefinedArguments().initializeListOfAllPredefinedArgumentNames();
        UniqueGenericParameterList allArgs = (UniqueGenericParameterList)_argumentsProcessor.getAllArgumentsIncludingPredefined()
                                                                                            .clone();

        //Sort the parameters before adding items.
        allArgs.sort();
        for(int i = 0; i < allArgs.getParameters().size(); i++)
        {
            GenericParameter argAndValue = allArgs.getParameters().get(i);

            if(argAndValue.getValue() == null || argAndValue.getValue().trim().length() == 0)
            {
                item = new JMenuItem(String.format("    %1$s ( %2$s )",
                                                   argAndValue.getName(),
                                                   _argumentsProcessor.getUndefinedArgumentValue()));
            }
            else
            {
                item = new JMenuItem(String.format("    %1$s ( = %2$s )", argAndValue.getName(), argAndValue.getValue()));
            }
//            item.setUI(new ArgumentPopupMenuItemUI());
            item.setName(argAndValue.getName());
            _regularItems.add(item);
            this.add(item);
            item.addActionListener(this);
        }

        if(includeFunctions)
        {
            //FUNCTIONS
            this.addSeparator();
            this.add(new JMenuItem("Select Function:"));
            String[] names = _argumentsProcessor.getFunctionNames();
            for(int i = 0; i < names.length; i++)
            {
                item = new JMenuItem(String.format("    %1$s", names[i]));
                item.setName(names[i]);
                _functionItems.add(item);
//                item.setUI(new ArgumentPopupMenuItemUI());
                this.add(item);
                item.addActionListener(this);
            }
        }
    }

    public void setParentComponentForLocatingDialogs(JComponent comp)
    {
        this._parentComponentForLocatingDialogs = comp;
    }

    public void addListener(ArgumentPopupMenuListener listener)
    {
        this._listeners.add(listener);
    }

    public void removeListener(ArgumentPopupMenuListener listener)
    {
        this._listeners.remove(listener);
    }

    public void fireArgumentChosen(Argument arg)
    {
        for(int i = 0; i < _listeners.size(); i++)
        {
            this._listeners.get(i).argumentChosen(arg);
        }
    }

    public void fireClearFieldChosen()
    {
        for(int i = 0; i < _listeners.size(); i++)
        {
            this._listeners.get(i).clearFieldChosen();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e)
    {
        JMenuItem item = (JMenuItem)e.getSource();

        Argument arg = new Argument();
        arg.setArgumentName(item.getName());

        if(this._regularItems.indexOf(item) >= 0)
        {
            this.fireArgumentChosen(arg);
        }
        else if(this._functionItems.indexOf(item) >= 0)
        {
            ArgumentFunctionParameterEditingPanel editingPanel = this._argumentsProcessor.buildEditingPanel(item.getName());
            int value = JOptionPane.showConfirmDialog(_parentComponentForLocatingDialogs, editingPanel, "Specify "
                + item.getName() + " Parameters", JOptionPane.OK_CANCEL_OPTION, JOptionPane.QUESTION_MESSAGE);
            editingPanel.makeEditedArgumentReflectPanel();
            if(value == JOptionPane.OK_OPTION)
            {
                fireArgumentChosen(editingPanel.getEditedArgument());
                setVisible(false);
            }
            else
            {
                setVisible(false);
            }
        }
        else if(item.getText().equals("Clear Field"))
        {
            this.fireClearFieldChosen();
        }
    }

//DO NOT REMOVE COMMENTED CODE BELOW!!!!!!!!!!
//    /**
//     * Only trigger the superclass version of this method if a JOptionPane dialog is not currently being displayed.
//     */
//    @Override
//    public void menuSelectionChanged(boolean isIncluded)
//    {
//        if(!_dialogIsOpen)
//        {
//            super.menuSelectionChanged(isIncluded);
//        }
//    }

    //DO NOT REMOVE COMMENTED CODE BELOW!!!!!!!!!!
//    /**
//     * Overrides the BasicMenuItemUI reversing the order of events in doClick. Specifically, it tells the menu item to
//     * doClick before clearing the menu path (which results in the popup being closed).
//     * 
//     * @author herrhd
//     */
//    public class ArgumentPopupMenuItemUI extends BasicMenuItemUI
//    {
//
//        @Override
//        protected void doClick(MenuSelectionManager msm)
//        {
//            // Auditory cue
//            //if (! isInternalFrameSystemMenu()) {
//            //        BasicLookAndFeel.playSound(menuItem, getPropertyPrefix() +
//            //                                   ".commandSound");
//            //}
//            // Visual feedback
//            if(msm == null)
//            {
//                msm = MenuSelectionManager.defaultManager();
//            }
//            menuItem.doClick(0);
//            msm.clearSelectedPath();
//        }
//    }
}
