package ohd.hseb.hefs.utils.arguments;

/**
 * Anything that uses an ArgumentPopupMenu should implement this listener to receive selections.
 * 
 * @author herrhd
 */
public interface ArgumentPopupMenuListener
{
    /**
     * Fired when the user selects an argument or a function + parameters.
     * 
     * @param arg The Argument object specifying the arg name and function parameters.
     */
    public void argumentChosen(Argument arg);

    /**
     * Fired when the user selects the clear field menu item.
     */
    public void clearFieldChosen();
}
