package ohd.hseb.hefs.utils.arguments;

import java.util.List;

import javax.swing.JComboBox;

import ohd.hseb.hefs.utils.plugins.UniqueGenericParameterList;

/**
 * A {@link JComboBox} that provides a list of all of the arguments, predefined and location specific, pulled from a
 * provided {@link ArgumentsProcessor}. It also includes a static method that returns all argument name pulled from an
 * {@link ArgumentsProcessor}.
 * 
 * @author hank.herr
 */
public class ArgumentSelectionComboBox extends JComboBox// implements ActionListener, ArgumentPopupMenuListener
{
    private static final long serialVersionUID = 1L;

    public ArgumentSelectionComboBox(final ArgumentsProcessor argProc)
    {
        super(getArgumentNames(argProc).toArray());
    }

    /**
     * @return {@link List} of the names of the arguments, including predefined arguments, pulled from the provided
     *         {@link ArgumentsProcessor}.
     */
    public static List<String> getArgumentNames(final ArgumentsProcessor argProc)
    {
        argProc.getPredefinedArguments().initializeListOfAllPredefinedArgumentNames();
        final UniqueGenericParameterList allArgs = (UniqueGenericParameterList)argProc.getAllArgumentsIncludingPredefined()
                                                                                      .clone();
        return allArgs.getParameterNames();
    }
}
