package ohd.hseb.hefs.utils.arguments;

import java.util.Calendar;
import java.util.TimeZone;

import ohd.hseb.util.misc.HCalendar;

/**
 * Implementation of PredefinedArguments, in which only one argument is predefined: SYSTEM_TIME. It returns the Java
 * system time by default. Subclasses of this may return their own system time values, of course.
 * 
 * @author herrhd
 */
public class DefaultPredefinedArguments extends PredefinedArguments
{

    public static final String SYSTEM_TIME = "systemTime";

    @Override
    public String getDefaultValue(String argName)
    {
        if(argName.equalsIgnoreCase(SYSTEM_TIME))
        {
            return HCalendar.buildDateTimeTZStr(Calendar.getInstance(TimeZone.getTimeZone("GMT")));
        }
        return null;
    }

    @Override
    protected void initializeListOfAllPredefinedArgumentNames()
    {
        this.getListOfPredefinedArgumentNames().add(SYSTEM_TIME);
    }

}
