package ohd.hseb.hefs.utils.arguments;

import java.util.ArrayList;
import java.util.List;

import ohd.hseb.hefs.utils.plugins.GenericParameterList;

/**
 * A list of "predefined" arguments, or default arguments (I don't use default, because it can be misunderstood too
 * easily). This must be subclassed by a specific implementation to be used.
 * 
 * @author hank.herr
 */
public abstract class PredefinedArguments
{
    /**
     * List of predefined arguments and values.
     */
    private final GenericParameterList _predefinedArgumentList = new GenericParameterList();

    /**
     * Names of allowed predefined arguments.
     */
    public final List<String> _allowedPredefinedArgumentNames = new ArrayList<String>();

    protected abstract void initializeListOfAllPredefinedArgumentNames();

    public List<String> getListOfPredefinedArgumentNames()
    {
        return _allowedPredefinedArgumentNames;
    }

    public boolean isPredefinedArgumentDefined(String name)
    {
        return this._predefinedArgumentList.doesParameterExist(name);
    }

    /**
     * @param argName Name of argument.
     * @return Default, or predefined, value of the argument with the passed in name.
     */
    public abstract String getDefaultValue(String argName);
}
