package ohd.hseb.hefs.utils.collect;

import static com.google.common.base.Preconditions.checkPositionIndex;

import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

import net.jcip.annotations.Immutable;

/**
 * An immutable, empty list.
 * 
 * @author alexander.garbarino
 * @param <E>
 */
@Immutable
public class EmptyList<E> extends AbstractList<E>
{
    @Override
    public int size()
    {
        return 0;
    }

    @Override
    public boolean isEmpty()
    {
        return true;
    }

    @Override
    public boolean contains(final Object o)
    {
        return false;
    }

    @Override
    public Iterator<E> iterator()
    {
        return new NoneIterator();
    }

    @Override
    public Object[] toArray()
    {
        return new Object[0];
    }

    @SuppressWarnings("unchecked")
    @Override
    public <T> T[] toArray(final T[] a)
    {
        return ((T[])Array.newInstance(a.getClass().getComponentType(), 0));
    }

    @Override
    public boolean add(final E e)
    {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(final Object o)
    {
        return false;
    }

    @Override
    public boolean containsAll(final Collection<?> c)
    {
        return false;
    }

    @Override
    public boolean addAll(final Collection<? extends E> c)
    {
        if(c.isEmpty())
        {
            return false;
        }
        else
        {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public boolean addAll(final int index, final Collection<? extends E> c)
    {
        if(c.isEmpty())
        {
            return false;
        }
        else
        {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public boolean removeAll(final Collection<?> c)
    {
        return false;
    }

    @Override
    public boolean retainAll(final Collection<?> c)
    {
        return false;
    }

    @Override
    public void clear()
    {
    }

    @Override
    public E get(final int index)
    {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public E set(final int index, final E element)
    {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(final int index, final E element)
    {
        throw new UnsupportedOperationException();
    }

    @Override
    public E remove(final int index)
    {
        throw new UnsupportedOperationException();
    }

    @Override
    public int indexOf(final Object o)
    {
        return -1;
    }

    @Override
    public int lastIndexOf(final Object o)
    {
        return -1;
    }

    @Override
    public ListIterator<E> listIterator()
    {
        return new NoneIterator();
    }

    @Override
    public ListIterator<E> listIterator(final int index)
    {
        return new NoneIterator(index);
    }

    @Override
    public List<E> subList(final int fromIndex, final int toIndex)
    {
        checkPositionIndex(fromIndex, 0);
        checkPositionIndex(toIndex, 0);
        return this;
    }

    @Override
    public int hashCode()
    {
        return 1;
    }

    private class NoneIterator implements ListIterator<E>
    {
        private NoneIterator()
        {
            this(0);
        }

        private NoneIterator(final int index)
        {
            checkPositionIndex(index, 0);
        }

        @Override
        public boolean hasNext()
        {
            return false;
        }

        @Override
        public E next()
        {
            throw new NoSuchElementException();
        }

        @Override
        public boolean hasPrevious()
        {
            return false;
        }

        @Override
        public E previous()
        {
            throw new NoSuchElementException();
        }

        @Override
        public int nextIndex()
        {
            return 0;
        }

        @Override
        public int previousIndex()
        {
            return -1;
        }

        @Override
        public void remove()
        {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(final E e)
        {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(final E e)
        {
            throw new UnsupportedOperationException();
        }
    }
}
