package ohd.hseb.hefs.utils.collect;

import ohd.hseb.hefs.utils.tools.IterableTools;

/**
 * Function of two arguments of the same type. Used for reducing collections. See
 * {@link IterableTools#reduce(Reduction, Iterable)} for an example of usage.
 * 
 * @author alexander.garbarino
 * @param <T>
 */
public interface Reduction<T>
{
    /**
     * The initial value to use when reducing. Generally the identity value.
     * 
     * @return the initial value
     */
    T initial();

    /**
     * The actual reduction operation to perform
     * 
     * @param left the left input
     * @param right the right input
     * @return the result
     */
    T reduce(T left, T right);
}
