package ohd.hseb.hefs.utils.datetime;

import javax.swing.JDialog;

/**
 * @author gzhou
 */

public interface HDateChooserListener
{
    /**
     * Called when the user cancels the HDateChooserDialog.
     * 
     * @param caller The source dialog, which may be either a HDateChooserDialog or an HRelativeDateChooserDialog.
     */
    void dateChooseCancelled(JDialog caller);

    /**
     * Called when a date is chosen, which can be acquired from caller.
     * 
     * @param caller The source dialog, which may be either a HDateChooserDialog or an HRelativeDateChooserDialog.
     */
    public void dateChosen(JDialog caller);
}
