package ohd.hseb.hefs.utils.dist;

import ohd.hseb.hefs.utils.dist.types.ContinuousDist;
import ohd.hseb.hefs.utils.dist.types.DiscreteDist;
import ohd.hseb.util.data.DataSet;

/**
 * Implement if the distribution can be fit to data. This is implemented by {@link ContinuousDist} and
 * {@link DiscreteDist} since all distributions presently can be fit to data.
 * 
 * @author hankherr
 */
public interface DataFittingDistribution
{
    /**
     * Calls {@link #fitToData(DataSet, double[])} with a null parameter array.
     */
    public void fitToData(DataSet data) throws DataFittingDistributionException;

    /**
     * @param data {@link DataSet} that contains the data to which to fit the distribution. Be sure to set the fit
     *            sample and cdf variables appropriately using {@link DataSet#setFitSampleVariable(int)} and
     *            {@link DataSet#setFitCDFVariable(int)} as needed.
     * @param fitParms The parameters of the fit, which are distribution specific..
     * @return True if successful, false if a problem occurs.
     */
    public void fitToData(DataSet data, double[] fitParms) throws DataFittingDistributionException;
}
