package ohd.hseb.hefs.utils.dist;

import ohd.hseb.hefs.utils.dist.types.ContinuousDist;
import ohd.hseb.util.data.DataSet;

/**
 * Interface implemented by any {@link ContinuousDist} that is able to fit itself to L-moments.
 * 
 * @author hankherr
 */

public interface LMomentsFittingDistribution
{
    /**
     * Calculate the L-moment ratios of the sample data and convert them to parameters.
     * 
     * @param data The data to which to fit the distribution.
     */
    public void fitToLMoments(DataSet data) throws DataFittingDistributionException;

    /**
     * Convert the L-moment ratios into parameters.
     * 
     * @param lmoments The ratios as an array of doubles. Could be any number of moments, but typically only a maximum
     *            of five are used in distribution fitting (Kappa distribution has 5 parameters).
     */
    public void fitToLMoments(double[] lmoments) throws DataFittingDistributionException;
}