package ohd.hseb.hefs.utils.dist;

import ohd.hseb.hefs.utils.dist.types.ContinuousDist;

/**
 * Interface implemented by any {@link ContinuousDist} that is able to fit itself to moments: mean and coefficient of
 * variation (computed from the standard deviation and the mean).
 * 
 * @author hankherr
 */
public interface MomentsFittingDistribution
{
    /**
     * Fit the distribution given the mean and coefficient of variation.
     * 
     * @throws DataFittingDistributionException
     */
    public void fitToMoments(final double mean, final double coefficientOfVariation) throws DataFittingDistributionException;
}
