package ohd.hseb.hefs.utils.dist;

import ohd.hseb.util.data.DataSet;

/**
 * A distribution must implement this in order for
 * {@link DistributionTools#optimizeShiftFitForBoundedBelowDistribution(ShiftOptimizationFittingDistribution, DataSet, double[])}
 * to be used in conjunction with a non-shift parameter estimation routine in order to optimize the position of the
 * shift parameter.
 * 
 * @author Hank.Herr
 */
public interface ShiftOptimizationFittingDistribution
{
    /**
     * For the provided shift parameter, estimate the parameters of the implementing distribution.
     * 
     * @param data Data specifying the samples and computed empirical probabilities.
     * @param shift The shift for which to estimate the other parameters.
     * @throws DataFittingDistributionException
     */
    public void estimateParameters(final DataSet data, final double shift) throws DataFittingDistributionException;
}
