package ohd.hseb.hefs.utils.effect;

/**
 * Wrapper for a {@link Runnable} that allows it to be treated as an {@link Effect}.
 * 
 * @author alexander.garbarino
 */
public class RunnableEffect extends Effect<Object> implements Runnable
{
    private final Runnable _runnable;

    public RunnableEffect(Runnable runnable)
    {
        _runnable = runnable;
    }

    @Override
    public void perform(Object input)
    {
        run();
    }

    @Override
    public void run()
    {
        _runnable.run();
    }
}
