package ohd.hseb.hefs.utils.ftp;

import java.util.ArrayList;
import java.util.List;

import ohd.hseb.hefs.utils.xml.XMLReader;
import ohd.hseb.hefs.utils.xml.XMLReaderException;
import ohd.hseb.hefs.utils.xml.XMLTools;
import ohd.hseb.hefs.utils.xml.XMLWriter;
import ohd.hseb.hefs.utils.xml.XMLWriterException;
import ohd.hseb.util.misc.HString;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;

public class SFTPSettings implements XMLWriter, XMLReader
{
    private static String ME_STRING = "me";

    private String _serverName;
    private final List<String> _backupServerNames = new ArrayList<>();
    private String _userName = "anonymous";
    private String _password = "";
    private final String _xmlTagName;

    public SFTPSettings(final String xmlTagName, final String server)
    {
        _xmlTagName = xmlTagName;
        _serverName = server;
    }

    public SFTPConductor startFTPSession() throws Exception
    {
        return new SFTPConductor(this);
    }

    public void checkSettings() throws Exception
    {
        if((_serverName == null) || (_serverName.isEmpty()))
        {
            throw new Exception("The SFTP server name is not specified.");
        }
        if((_userName == null) || (_userName.isEmpty()))
        {
            throw new Exception("The SFTP user name is not specified.");
        }
        if(_password == null)
        {
            throw new Exception("The SFTP password is not specified.");
        }
    }

    public String getServerName()
    {
        return _serverName;
    }

    public void setServerName(final String serverName)
    {
        this._serverName = serverName;
    }

    /**
     * Add to the returned list directly if you wish to add backup servers.
     * 
     * @return {@link List} of {@link String}s that specify backup servers to try, in order, if the primary server
     *         fails.
     */
    public List<String> getBackupServerNames()
    {
        return _backupServerNames;
    }

    public String getUserName()
    {
        if(_userName.equals(ME_STRING))
        {
            return System.getProperty("user.name");
        }
        return _userName;
    }

    public void setUserName(final String userName)
    {
        this._userName = userName;
    }

    public String getPassword()
    {
        return _password;
    }

    public void setPassword(final String password)
    {
        this._password = password;
    }

    @Override
    public void setValueOfElement(final String elementName, final String value) throws XMLReaderException
    {
        if(elementName.equals("serverName"))
        {
            this._serverName = value;
        }
        else if(elementName.equals("backupServerName"))
        {
            _backupServerNames.add(value);
        }
        else if(elementName.equals("userName"))
        {
            this._userName = value;
        }
        else if(elementName.equals("password"))
        {
            this._password = value;
        }
    }

    @Override
    public XMLReader readInPropertyFromXMLElement(final String elementName, final Attributes attr) throws XMLReaderException
    {
        if(elementName.equals(getXMLTagName()))
        {
        }
        return null;
    }

    @Override
    public void finalizeReading() throws XMLReaderException
    {
    }

    @Override
    public void validate() throws XMLReaderException
    {
    }

    @Override
    public String getXMLTagName()
    {
        return _xmlTagName;
    }

    @Override
    public Element writePropertyToXMLElement(final Document request) throws XMLWriterException
    {
        final Element mainElement = request.createElement(getXMLTagName());
        mainElement.appendChild(XMLTools.createTextNodeElement(request, "serverName", getServerName()));
        for(final String backup: _backupServerNames)
        {
            mainElement.appendChild(XMLTools.createTextNodeElement(request, "backupServerName", backup));
        }
        mainElement.appendChild(XMLTools.createTextNodeElement(request, "userName", getUserName()));
        mainElement.appendChild(XMLTools.createTextNodeElement(request, "password", getPassword()));
        return mainElement;
    }

    @Override
    public boolean equals(final Object obj)
    {
        final SFTPSettings other = (SFTPSettings)obj;
        return ((_serverName.equals(other.getServerName()))
            && (_backupServerNames.equals(other.getBackupServerNames())) && (_userName.equals(other.getUserName())) && (_password.equals(other.getPassword())));
    }

    @Override
    public String toString()
    {
        return "FTPSettings: xmlTagName = '" + getXMLTagName() + "'; serverName = '" + _serverName
            + "'; backupServerNames = " + HString.buildStringFromList(_backupServerNames, ",") + "; userName = '"
            + _userName + "'; password = '" + _password + "'.";
    }

    @Override
    public XMLReader getReader()
    {
        return this;
    }

    @Override
    public XMLWriter getWriter()
    {
        return this;
    }
}
