package ohd.hseb.hefs.utils.gui.colors;

import java.awt.Color;
import java.util.ArrayList;

/**
 * A list of colors used for chart series. Use the static method {@link #getColorForIndex(int)} to acquire a color for
 * an index. The colors used in order: red, green, blue. yellow, magenta, cyan, darkGray, lightGray, orange, pink,
 * black.
 * 
 * @author hank.herr
 */
public class GenericListOfColors extends ArrayList<Color>
{
    private static final long serialVersionUID = 1L;

    private static GenericListOfColors COLORS_LIST = new GenericListOfColors();

    public GenericListOfColors()
    {
        super();
        add(Color.red);
        add(Color.green);
        add(Color.blue);
        add(Color.yellow);
        add(Color.magenta);
        add(Color.cyan);
        add(Color.darkGray);
        add(Color.lightGray);
        add(Color.orange);
        add(Color.pink);
        add(Color.black);
    }

    public Color getColor(final int index)
    {
        return this.get(index % this.size());
    }

    public static Color getColorForIndex(final int index)
    {
        return COLORS_LIST.get(index % COLORS_LIST.size());
    }
}
