/*
 * Created on Jun 1, 2007 To change the template for this generated file go to Window&gt;Preferences&gt;Java&gt;Code
 * Generation&gt;Code and Comments
 */
package ohd.hseb.hefs.utils.gui.colors;

import java.awt.Color;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Properties;

import ohd.hseb.hefs.utils.gui.tools.ColorTools;

/**
 * This class, when the constructor is called, loads colors from the system resource colors/colors.txt. These colors
 * correspond to X11 colors. When is {@link #retrieveColorFromName(String)} called, it will look through preset strings
 * based on Java colors, then through X11 color strings, and then treat it as RGB. It is recommended that the static
 * methods are used.
 * 
 * @author hank
 */
public class X11ColorStrings
{

    public static X11ColorStrings COLOR_STRING_SPECIFIER = null;

    public final static char X11_COLOR_SEPARATOR = ',';

    /**
     * Stores the X11 colors.
     */
    private Properties _colorSystemProperties;

    /**
     * Constructor loads the X11 colors into a SystemSettings file.
     */
    public X11ColorStrings() throws IOException, FileNotFoundException
    {
        if(ClassLoader.getSystemResource("colors/colors.txt") == null)
        {
            throw new FileNotFoundException("Resource file colors/colors.txt not found.");
        }
        else
        {
            final InputStreamReader reader = new InputStreamReader(ClassLoader.getSystemResource("colors/colors.txt")
                                                                              .openStream());
            _colorSystemProperties = new Properties();
            _colorSystemProperties.load(reader);
        }
    }

    /**
     * Returns the Color corresponding to the passed in name.
     * 
     * @param name The name of the color, according to colors.txt.
     * @return Color that it specifies.
     */
    public Color retrieveX11Color(final String name)
    {
        final String colorString = _colorSystemProperties.getProperty(name);
        if(colorString == null)
        {
            return null;
        }
        return ColorTools.processRGBString(colorString, X11_COLOR_SEPARATOR);
    }

    private Properties getColorSystemProperties()
    {
        return this._colorSystemProperties;
    }

    /**
     * Initialize the static variable COLOR_STRING_SPECIFIER.
     */
    public static void initializeColorStringSpecifierIfNeeded()
    {
        try
        {
            if(X11ColorStrings.COLOR_STRING_SPECIFIER == null)
            {
                X11ColorStrings.COLOR_STRING_SPECIFIER = new X11ColorStrings();
            }
        }
        catch(final IOException ioe)
        {
            X11ColorStrings.COLOR_STRING_SPECIFIER = null;
        }
    }

    public static Color retrieveColorFromName(final String name)
    {
        initializeColorStringSpecifierIfNeeded();
        if(X11ColorStrings.COLOR_STRING_SPECIFIER == null)
        {
            return null;
        }
        return X11ColorStrings.COLOR_STRING_SPECIFIER.retrieveX11Color(name);
    }

    @SuppressWarnings({"rawtypes", "unchecked"})
    public static ArrayList retrieveListOfColorNames()
    {
        initializeColorStringSpecifierIfNeeded();
        if(X11ColorStrings.COLOR_STRING_SPECIFIER == null)
        {
            return null;
        }
        return new ArrayList(X11ColorStrings.COLOR_STRING_SPECIFIER.getColorSystemProperties().keySet());
    }
}
