/*
 * Created on Dec 10, 2007 To change the template for this generated file go to Window&gt;Preferences&gt;Java&gt;Code
 * Generation&gt;Code and Comments
 */
package ohd.hseb.hefs.utils.gui.components;

import java.awt.Color;
import java.awt.FlowLayout;

import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import ohd.hseb.hefs.utils.gui.jtable.renderers.ColorCellEditor;
import ohd.hseb.hefs.utils.gui.tools.ColorTools;
import ohd.hseb.hefs.utils.gui.tools.HSwingFactory;

/**
 * Panel for selecting a color alpha. This is used within a {@link ColorCellEditor} and the
 * {@link ColorTools#chooseAlpha(java.awt.Component, Color)} and
 * {@link ColorTools#chooseColorWithAlpha(java.awt.Component, Color)} calls.
 * 
 * @author Hank.Herr
 */
public class AlphaColorChooserPanel extends AbstractColorChooserPanel implements ChangeListener
{

    private static final long serialVersionUID = 1L;
    private JSpinner _alphaSpinner;
    private JSlider _alphaSlider;
    private final int _initialAlpha;

    public AlphaColorChooserPanel(Color initialColor)
    {
        super();
        if(initialColor == null)
        {
            _initialAlpha = Color.BLACK.getAlpha();
        }
        else
        {
            _initialAlpha = initialColor.getAlpha();
        }
    }

    @Override
    protected void buildChooser()
    {
        _alphaSpinner = HSwingFactory.createJSpinner(null, 4, 0, 0, 255, 1);
        _alphaSlider = new JSlider(JSlider.HORIZONTAL, 0, 255, 0);
        _alphaSlider.setPaintLabels(true);
        _alphaSlider.setPaintTicks(true);
        _alphaSlider.setMajorTickSpacing(85);
        _alphaSlider.setMinorTickSpacing(17);
        this.setLayout(new FlowLayout(FlowLayout.CENTER));
        this.add(new JLabel("Transparency Level:"));
        this.add(_alphaSlider);
        this.add(_alphaSpinner);

        _alphaSlider.addChangeListener(this);
        _alphaSpinner.addChangeListener(this);

        _alphaSpinner.setValue(_initialAlpha);
        updateForSpinnerValueChange();
    }

    @Override
    public String getDisplayName()
    {
        return "Transparency";
    }

    @Override
    public Icon getLargeDisplayIcon()
    {
        return null;
    }

    @Override
    public Icon getSmallDisplayIcon()
    {
        return null;
    }

    @Override
    public void updateChooser()
    {
        _alphaSpinner.setValue(this.getColorSelectionModel().getSelectedColor().getAlpha());
    }

    private void updateForSpinnerValueChange()
    {
        _alphaSlider.removeChangeListener(this);
        _alphaSlider.setValue(((Number)_alphaSpinner.getModel().getValue()).intValue());
        _alphaSlider.addChangeListener(this);
        Color newColor = new Color(this.getColorSelectionModel().getSelectedColor().getRed(),
                                   this.getColorSelectionModel().getSelectedColor().getGreen(),
                                   this.getColorSelectionModel().getSelectedColor().getBlue(),
                                   ((Number)_alphaSpinner.getModel().getValue()).intValue());
        this.getColorSelectionModel().setSelectedColor(newColor);
    }

    @Override
    public void stateChanged(ChangeEvent arg0)
    {
        if(arg0.getSource() == _alphaSpinner)
        {
            updateForSpinnerValueChange();
        }
        else if(arg0.getSource() == _alphaSlider)
        {
            _alphaSpinner.setValue(_alphaSlider.getValue());
        }
    }

}
