package ohd.hseb.hefs.utils.gui.components;

import java.awt.Color;
import java.awt.Component;

import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;

public class BackgroundColorChangingComboBoxRenderer extends DefaultListCellRenderer
{
    private static final long serialVersionUID = 1L;

    private Color _backgroundColor = null;

    public void setBackgroundColor(Color c)
    {
        this._backgroundColor = c;
    }

    public void clearBackgroundColor()
    {
        this._backgroundColor = null;
    }

    @Override
    public Component getListCellRendererComponent(JList list,
                                                  Object value,
                                                  int index,
                                                  boolean isSelected,
                                                  boolean cellHasFocus)
    {
        Component comp = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        if(this._backgroundColor != null)
        {
            comp.setBackground(_backgroundColor);
        }
        return comp;
    }

}
