package ohd.hseb.hefs.utils.gui.components;

import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.SwingConstants;

/**
 * A {@link JLabel} that can be clicked on. The {@link JLabel} has a {@link MouseListener} attached to it which calls a
 * provided {@link ActionListener} when clicked. It also allows for having two icons, as well: one for when the mouse is
 * over the label and one for when it is not (this allows for creating, for example, a partially transparent icon which
 * becomes opaque when over it).
 * 
 * @author hank.herr
 */
@SuppressWarnings("serial")
public class ClickableJLabel extends JLabel
{

    public ClickableJLabel(final String text)
    {
        super(text);
        setDisabledIcon(null);
    }

    public ClickableJLabel(final String text, final Icon icon)
    {
        super(text, icon, SwingConstants.LEFT);
        setDisabledIcon(null);
    }

    public ClickableJLabel(final Icon icon)
    {
        super(icon);
        setDisabledIcon(null);
    }

    public ClickableJLabel(final String text, final ActionListener action)
    {
        super(text);
        addClickAction(action);
        setDisabledIcon(null);
    }

    public ClickableJLabel(final String text, final Icon icon, final ActionListener action)
    {
        super(text, icon, SwingConstants.LEFT);
        addClickAction(action);
        setDisabledIcon(null);
    }

    public ClickableJLabel(final Icon icon, final ActionListener action)
    {
        super(icon);
        addClickAction(action);
        setDisabledIcon(null);
    }

    /**
     * Call {@link BorderFactory#createEmptyBorder(int, int, int, int)} with the provided parameters and calls
     * {@link #setOpaque(boolean)} with false making the border transparent.
     */
    public void createTransparentMargin(final int top, final int left, final int bottom, final int right)
    {
        setBorder(BorderFactory.createEmptyBorder(top, left, bottom, right));
        setOpaque(false);
    }

    public void addClickAction(final ActionListener action)
    {
        addMouseListener(new MouseAdapter()
        {
            @Override
            public void mouseClicked(final MouseEvent e)
            {
                action.actionPerformed(null);
            }

            @Override
            public void mouseEntered(final MouseEvent e)
            {
                if(getDisabledIcon() != null)
                {
                    setEnabled(true);
                }
            }

            @Override
            public void mouseExited(final MouseEvent e)
            {
                if(getDisabledIcon() != null)
                {
                    setEnabled(false);
                }
            }
        });
    }

    public void setIconToUseWhenCursorIsNotOverLabel(final Icon icon)
    {
        //Set the opaqueness to true to ensure that when the label is disabled, only the label is repainted, not its 
        //parent.  This will avoid potential slow downs if the underlying panels take a long time to draw: the enabled
        //change should still be fast.
        setOpaque(true);
//        setBackground(HSwingFactory.TRANSPARENT);
        setDisabledIcon(icon);
        setEnabled(false);
    }

}
