package ohd.hseb.hefs.utils.gui.components;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;

import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;

/**
 * This panel displays the provided component in a {@link FlowLayout} with the alignment provided to the constructor.
 * The panel is not opaque, allowing mouse events to pass through to the underlying components. It is intended to serve
 * as a glass panel connected to a {@link JRootPane}, and can be added as such to a root pane by calling
 * {@link #addToPane(JRootPane)}.
 * 
 * @author hankherr
 */
@SuppressWarnings("serial")
public class ComponentPanelGlassPane extends JPanel
{

    /**
     * Empty constructor just sets the layout and make it not opaque.
     */
    public ComponentPanelGlassPane()
    {
        this.setOpaque(false);
    }

    /**
     * @param components Components to placed in the JPanel within a {@link FlowLayout} using {@link FlowLayout#LEADING}
     *            with horizontal and vertical gaps of 1 .
     * @param location One of the {@link FlowLayout} alignments, such as {@link FlowLayout#LEADING} (which will make the
     *            buttons appear as a tool bar at the top).
     */
    public ComponentPanelGlassPane(final Collection<Component> components, final int flowLayoutAlignment)
    {
        this.setLayout(new FlowLayout(flowLayoutAlignment, 1, 1));
        for(final Component c: components)
        {
            add(c);
        }
        this.setOpaque(false);
    }

    public void addToPane(final JRootPane pane)
    {
        pane.setGlassPane(this);
    }

    public void setPanelVisible(final boolean b)
    {
        setVisible(b);
    }

    /**
     * This is currently unused (I could never get it to work the way I wanted it to).
     * 
     * @param c
     */
    public void addMouseMotionListenerToMakeToolBarVisible(final Component c)
    {
        final MouseAdapter adapter = new MouseAdapter()
        {
            @Override
            public void mouseEntered(final MouseEvent e)
            {
                setPanelVisible(true);
            }

            @Override
            public void mouseExited(final MouseEvent e)
            {
                setPanelVisible(false);
            }
        };

        c.addMouseMotionListener(adapter);
    }

    /**
     * Will return false unless one of the components within this glass pane returns true.
     */
    @Override
    public boolean contains(final int x, final int y)
    {
        final Component[] components = getComponents();
        for(int i = 0; i < components.length; i++)
        {
            final Component component = components[i];
            final Point containerPoint = SwingUtilities.convertPoint(this, x, y, component);
            if(component.contains(containerPoint))
            {
                return true;
            }
        }
        return false;
    }
}
