package ohd.hseb.hefs.utils.gui.components;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.SwingConstants;
import javax.swing.border.Border;

/**
 * This was copied from on-line and may not work with every component! Note that to make it so that a JLabel can be the
 * component, you will want to set the JLabel to be opaque (setOpaque(true)) to avoid the baseBorder line being drawn
 * through it.
 * 
 * @author hank.herr
 */
public class ComponentTitledBorder implements Border, MouseListener, SwingConstants
{
    int _offset = 5;

    private final Component _componentInBorder;
    private final JComponent _borderedComponent;
    private Rectangle _rect;
    private final Border _baseBorder;

    public ComponentTitledBorder(Component componentInBorder, JComponent borderedComponent, Border baseBorder)
    {
        this._componentInBorder = componentInBorder;
        this._borderedComponent = borderedComponent;
        this._baseBorder = baseBorder;
        _borderedComponent.addMouseListener(this);
    }

    @Override
    public boolean isBorderOpaque()
    {
        return true;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height)
    {
        Insets borderInsets = _baseBorder.getBorderInsets(c);
        Insets insets = getBorderInsets(c);
        int temp = (insets.top - borderInsets.top) / 2;
        _baseBorder.paintBorder(c, g, x, y + temp, width, height - temp);
        Dimension size = _componentInBorder.getPreferredSize();
        _rect = new Rectangle(_offset, 0, size.width, size.height);
        final CellRendererPane cellRendererPane = new CellRendererPane();
        cellRendererPane.paintComponent(g, _componentInBorder, (Container)c, this._rect);
        //SwingUtilities.paintComponent(g, comp, (Container)c, rect);
    }

    @Override
    public Insets getBorderInsets(Component c)
    {
        Dimension size = _componentInBorder.getPreferredSize();
        Insets insets = _baseBorder.getBorderInsets(c);
        insets.top = Math.max(insets.top, size.height);
        return insets;
    }

    private void dispatchEvent(MouseEvent me)
    {
        if(_rect != null && _rect.contains(me.getX(), me.getY()))
        {
            Point pt = me.getPoint();
            pt.translate(-_offset, 0);
            _componentInBorder.setBounds(_rect);
            _componentInBorder.dispatchEvent(new MouseEvent(_componentInBorder,
                                                            me.getID(),
                                                            me.getWhen(),
                                                            me.getModifiersEx(),
                                                            pt.x,
                                                            pt.y,
                                                            me.getClickCount(),
                                                            me.isPopupTrigger(),
                                                            me.getButton()));
            if(!_componentInBorder.isValid())
                _borderedComponent.repaint();
        }
    }

    @Override
    public void mouseClicked(MouseEvent me)
    {
        dispatchEvent(me);
    }

    @Override
    public void mouseEntered(MouseEvent me)
    {
        dispatchEvent(me);
    }

    @Override
    public void mouseExited(MouseEvent me)
    {
        dispatchEvent(me);
    }

    @Override
    public void mousePressed(MouseEvent me)
    {
        dispatchEvent(me);
    }

    @Override
    public void mouseReleased(MouseEvent me)
    {
        dispatchEvent(me);
    }
}
