package ohd.hseb.hefs.utils.gui.components;

import static com.google.common.collect.Lists.newArrayList;

import java.awt.TextField;

import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JFormattedTextField.AbstractFormatter;

import ohd.hseb.hefs.utils.arguments.ArgumentInsertingTextFieldComboBoxEditor;
import ohd.hseb.hefs.utils.gui.tools.AllowSpecifiedValuesFormatter;
import ohd.hseb.hefs.utils.gui.tools.OrCompositeFormatter;

/**
 * A cell editor which is like a {@link JFormattedTextField} with additional options in a {@link JComboBox}.<br>
 * <br>
 * (Hank) This does not work quite right. I had problems getting it to react properly to focus lost events and pressing
 * enter within the RFC Forecast table PEDTSEP code editing. I switched that over to using a straight editable combo box
 * with a focus listener ({@link ArgumentInsertingTextFieldComboBoxEditor} is used as the {@link TextField} editor of
 * the combo box). I'm going to leave it here, but if it is to be used, the bugs must be worked out.
 * 
 * @author alexander.garbarino
 */
@SuppressWarnings("serial")
public class ExtendedCellEditor extends DefaultCellEditor
{
    public ExtendedCellEditor(final AbstractFormatter baseFormatter, final Iterable<?> comboItems)
    {
        super(makeComboBox(baseFormatter, comboItems));
    }

    public ExtendedCellEditor(final AbstractFormatter baseFormatter, final Object... comboItems)
    {
        super(makeComboBox(baseFormatter, newArrayList(comboItems)));
    }

    private static JComboBox makeComboBox(final AbstractFormatter baseFormatter, final Iterable<?> comboItems)
    {
        final JComboBox box = new JComboBox();
        for(final Object item: comboItems)
        {
            box.addItem(item);
        }
        box.setEditable(true);

        @SuppressWarnings({"unchecked", "rawtypes"})
        final AbstractFormatter formatter = new OrCompositeFormatter(baseFormatter,
                                                                     new AllowSpecifiedValuesFormatter(String.class,
                                                                                                       comboItems));
        final FormattedComboBoxEditor editor = new FormattedComboBoxEditor(formatter);
        box.setEditor(editor);

        return box;
    }
}
