package ohd.hseb.hefs.utils.gui.components;

import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.text.ParseException;

import javax.swing.ComboBoxEditor;
import javax.swing.JFormattedTextField;
import javax.swing.JFormattedTextField.AbstractFormatter;
import javax.swing.JFormattedTextField.AbstractFormatterFactory;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.text.DefaultFormatterFactory;

/**
 * A {@link ComboBoxEditor} that makes use of a {@link JFormattedTextField}.
 * 
 * @author alexander.garbarino
 */
@SuppressWarnings("serial")
public class FormattedComboBoxEditor extends BasicComboBoxEditor
{
    private final AbstractFormatterFactory _formatterFactory;

    public FormattedComboBoxEditor(AbstractFormatter formatter)
    {
        this(new DefaultFormatterFactory(formatter));
    }

    public FormattedComboBoxEditor(AbstractFormatterFactory factory)
    {
        _formatterFactory = factory;
        // createEditorComponent() is called before _formatterFactory is set, so set it here.
        getEditorComponent().setFormatterFactory(_formatterFactory);
    }

    @Override
    protected JFormattedTextField createEditorComponent()
    {
        final JFormattedTextField editor = new JFormattedTextField()
        {
            {
                addFocusListener(new FocusAdapter()
                {
                    @Override
                    public void focusGained(final FocusEvent e)
                    {
                        SwingUtilities.invokeLater(new Runnable()
                        {
                            @Override
                            public void run()
                            {
                                ((JFormattedTextField)e.getSource()).selectAll();
                            }
                        });
                    }

                });
            }
        };
        if(_formatterFactory != null)
        {
            editor.setFormatterFactory(_formatterFactory);
        }
//        editor.setBorder(null);
        return editor;
    }

    @Override
    public JFormattedTextField getEditorComponent()
    {
        return (JFormattedTextField)super.getEditorComponent();
    }

    @Override
    public void setItem(Object anObject)
    {
        getEditorComponent().setValue(anObject);
    }

    @Override
    public Object getItem()
    {
        try
        {
            getEditorComponent().commitEdit();
        }
        catch(ParseException e)
        {
        }
        return getEditorComponent().getValue();
    }

}
