package ohd.hseb.hefs.utils.gui.components;

import java.awt.Component;
import java.util.Vector;

import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;

import ohd.hseb.hefs.utils.gui.tools.ListCellRendererModifier;

/**
 * {@link JList} that will automatically modify its renderer if its model implements {@link ListCellRendererModifier}.
 * 
 * @author alexander.garbarino
 */
@SuppressWarnings("serial")
public class GenericJList extends JList
{
    public GenericJList()
    {
        super();
    }

    public GenericJList(ListModel dataModel)
    {
        super(dataModel);
    }

    public GenericJList(Object[] listData)
    {
        super(listData);
    }

    public GenericJList(Vector<?> listData)
    {
        super(listData);
    }

    @Override
    public void setCellRenderer(ListCellRenderer renderer)
    {
        if(!(renderer instanceof ModelCellRenderer))
        {
            renderer = new ModelCellRenderer(renderer);
        }
        super.setCellRenderer(renderer);
    }

    private class ModelCellRenderer implements ListCellRenderer
    {
        private final ListCellRenderer _delegate;

        private ModelCellRenderer(ListCellRenderer delegate)
        {
            _delegate = delegate;
        }

        @Override
        public Component getListCellRendererComponent(JList list,
                                                      Object value,
                                                      int index,
                                                      boolean isSelected,
                                                      boolean cellHasFocus)
        {
            Component component = _delegate.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            ListModel model = getModel();
            if(model instanceof ListCellRendererModifier)
            {
                component = ((ListCellRendererModifier)model).modifyListCellRendererComponent(component,
                                                                                              list,
                                                                                              value,
                                                                                              index,
                                                                                              isSelected,
                                                                                              cellHasFocus);
            }
            return component;
        }

    }
}
