package ohd.hseb.hefs.utils.gui.components;

import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;

import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import javax.swing.SwingUtilities;

/**
 * GenericSpinner includes a {@link MouseWheelListener} by default. Call the methods
 * {@link #disableDefaultMouseWheelListener()} to disable it or {@link #enableDefaultMouseWheelListener()} to reenable
 * it.
 * 
 * @author hankherr
 */
@SuppressWarnings("serial")
public class GenericSpinner extends JSpinner
{
    private MouseWheelListener _defaultMouseWheelListener = null;

    {
        _defaultMouseWheelListener = new PrivateWheelListener();
        addMouseWheelListener(_defaultMouseWheelListener);
    }

    public GenericSpinner()
    {
        super();
    }

    public GenericSpinner(final SpinnerModel model)
    {
        super(model);
    }

    private class PrivateWheelListener implements MouseWheelListener
    {
        @Override
        public void mouseWheelMoved(final MouseWheelEvent e)
        {
            Object next;
            if(e.getWheelRotation() < 0)
            {
                next = getNextValue();
            }
            else
            {
                next = getPreviousValue();
            }
            if(next != null)
            {
                setValue(next);
            }
        }
    }

    /**
     * Removes mouse wheel listener for the spinner.
     */
    protected void disableDefaultMouseWheelListener()
    {
        removeMouseWheelListener(_defaultMouseWheelListener);
    }

    /**
     * Adds mouse wheel listener for the spinner.
     */
    protected void enableDefaultMouseWheelListener()
    {
        addMouseWheelListener(_defaultMouseWheelListener);
    }

    @Override
    public void setEditor(final JComponent editorComponent)
    {
        final JSpinner.DefaultEditor editor = (JSpinner.DefaultEditor)editorComponent;

        super.setEditor(editor);

        editor.getTextField().addFocusListener(new FocusAdapter()
        {
            @Override
            public void focusGained(final FocusEvent e)
            {
                SwingUtilities.invokeLater(new Runnable()
                {
                    @Override
                    public void run()
                    {
                        ((JFormattedTextField)e.getSource()).selectAll();
                    }
                });
            }
        });
    }
}
