package ohd.hseb.hefs.utils.gui.components;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;

import javax.swing.JPanel;

/**
 * Simple JPanel with an internal image to display.
 * 
 * @author hank
 */
public class HCanvas extends JPanel
{
    private static final long serialVersionUID = 1L;
    final static String CLASSNAME = "HCanvas";

    /**
     * The Image to display.
     */
    Image _img;

    /**
     * Its size.
     */
    Dimension _size = null;

    public HCanvas(Image img)
    {
        _img = img;
    }

    public HCanvas()
    {
        _img = null;
    }

    public HCanvas(Image img, Dimension imageSize)
    {
        _img = img;
        _size = imageSize;
    }

    public void setImage(Image img)
    {
        _img = img;
    }

    @Override
    public void paint(Graphics g)
    {
        // drawing image onto the canvas. 
        if(_img == null)
        {
            return;
        }

        if(_size == null)
        {
            g.drawImage(_img, 0, 0, this);
        }
        else
        {
            g.drawImage(_img,
                        0,
                        0,
                        (int)_size.getWidth(),
                        (int)_size.getHeight(),
                        0,
                        0,
                        _img.getWidth(this),
                        _img.getHeight(this),
                        this);
        }
    }
}
