package ohd.hseb.hefs.utils.gui.components;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;

import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

import ohd.hseb.hefs.utils.filechooser.HGlobalFileChooser;
import ohd.hseb.hefs.utils.gui.tools.SelfListeningButton;
import ohd.hseb.hefs.utils.gui.tools.SwingTools;

import com.google.common.collect.Iterables;
import com.google.common.io.Files;

@SuppressWarnings("serial")
public class ImportPanel extends JPanel
{
    private final String _title;
    private final File _baseLocation;
    private final File[] _importLocations;
    private final ImportRow[] _rows;

    public ImportPanel(String title, File baseLocation, Iterable<File> importLocations)
    {
        this(title, baseLocation, Iterables.toArray(importLocations, File.class));
    }

    public ImportPanel(String title, File baseLocation, File... importLocations)
    {
        _title = title;
        _baseLocation = baseLocation;
        _importLocations = importLocations;
        _rows = new ImportRow[_importLocations.length];

        initialize();
    }

    private void initialize()
    {
        this.setLayout(new BoxLayout(this, BoxLayout.Y_AXIS));
        for(int i = 0; i < _importLocations.length; i++)
        {
            _rows[i] = new ImportRow(i);
            this.add(_rows[i]);
        }

        this.setPreferredSize(new Dimension(600, _rows.length * 35 + 20));

        // Performs imports, disposes if in dialog.
        this.add(new SelfListeningButton("Import")
        {
            @Override
            public void actionPerformed(ActionEvent e)
            {
                performImport();
                ImportDialog dialog = SwingTools.getParentOfClass(ImportPanel.this, ImportDialog.class);
                if(dialog != null)
                {
                    dialog.dispose();
                }
            }
        });
    }

    public void performImport()
    {
        for(int i = 0; i < _rows.length; i++)
        {
            File file = new File(_rows[i]._field.getText());
            try
            {
                Files.copy(file, _importLocations[i]);
            }
            catch(IOException e)
            {
                JOptionPane.showMessageDialog(this, "Could not import file " + _importLocations[i] + ".");
            }
        }
    }

    private class ImportRow extends JPanel
    {
        private final int _index;

        private final JTextField _field;

        private ImportRow(int index)
        {
            _index = index;

            _field = new JTextField();

            JButton button = new PickFileButton();

            this.setLayout(new GridBagLayout());
            GridBagConstraints cons = new GridBagConstraints();
            cons.gridx = GridBagConstraints.RELATIVE;
            cons.gridy = 0;
            cons.weightx = 0;
            cons.weighty = 1;
            cons.fill = GridBagConstraints.HORIZONTAL;
            this.add(new JLabel(_importLocations[_index].getName() + "  :  "), cons);
            cons.weightx = 1;
            cons.insets = new Insets(0, 10, 0, 10);
            this.add(_field, cons);
            cons.weightx = 0;
            cons.insets = new Insets(0, 0, 0, 0);
            this.add(button, cons);
        }

        private class PickFileButton extends SelfListeningButton
        {
            private PickFileButton()
            {
                super("Select File");
            }

            @Override
            public void actionPerformed(ActionEvent e)
            {
                String name = _importLocations[_index].getName();
                String filter = name.substring(name.lastIndexOf(".") + 1);

                HGlobalFileChooser fileChooser = new HGlobalFileChooser(_baseLocation.getPath());
                fileChooser.addFileFilter(filter, "Same File Type as Target");
                fileChooser.setDialogTitle(_title);
                File file = fileChooser.chooseFile(JFileChooser.FILES_ONLY, ImportPanel.this);
                if(file != null)
                {
                    _field.setText(file.getAbsolutePath());
                }
            }
        }
    }
}
