package ohd.hseb.hefs.utils.gui.components;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JMenuItem;

/**
 * This special {@link JButton} subclass allows for a JButton to be mapped to a {@link JMenuItem}, so that whenever the
 * button is clicked it is equivalent to triggering the menu item. The enabled status of this JButton is tied to the
 * associated JMenuItem; when it is disabled, this will be disabled.
 * 
 * @author hank
 */
public class MenuItemTriggeringButton extends JButton implements ActionListener, PropertyChangeListener
{
    private static final long serialVersionUID = 1L;

    private JMenuItem _menuItem;

    public MenuItemTriggeringButton(String text, JMenuItem menuItem)
    {
        super(text);
        _menuItem = menuItem;
        addActionListener(this);
        if(menuItem != null)
        {
            setToolTipText(menuItem.getText());
            _menuItem.addPropertyChangeListener(this);
        }
    }

    public MenuItemTriggeringButton(Icon icon, JMenuItem menuItem)
    {
        super(icon);
        _menuItem = menuItem;
        addActionListener(this);
        if(menuItem != null)
        {
            setToolTipText(menuItem.getText());
            _menuItem.addPropertyChangeListener(this);
        }
    }

    @Override
    public void actionPerformed(ActionEvent arg0)
    {
        _menuItem.doClick();
    }

    public void setMenuItem(JMenuItem item)
    {
        _menuItem = item;
        setToolTipText(_menuItem.getText());
        _menuItem.addPropertyChangeListener(this);
    }

    /**
     * React to any change in the menu item enabled status by setting this button to match it.
     */
    @Override
    public void propertyChange(PropertyChangeEvent arg0)
    {
        if(arg0.getPropertyName().equalsIgnoreCase("enabled"))
        {
            this.setEnabled(_menuItem.isEnabled());
        }
    }

}
