package ohd.hseb.hefs.utils.gui.components;

import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.text.Format;

import javax.swing.JFormattedTextField;
import javax.swing.SwingUtilities;
import javax.swing.text.MaskFormatter;

/**
 * Special {@link JFormattedTextField} that reverts the last acceptable version of the text field whenever a
 * {@link JFormattedTextField#commitEdit()} fails. Its not clear to me, right now, why this is needed, since a
 * {@link JFormattedTextField} will automatically do this if needed, except that it does include a focusGained to
 * selectAll mechanism.
 * 
 * @author hank.herr
 */
public class RevertingJFormattedTextField extends JFormattedTextField
{
    private static final long serialVersionUID = 1L;

    public RevertingJFormattedTextField()
    {
        super();
        addFocusListener();
    }

    public RevertingJFormattedTextField(final Format format)
    {
        super(format);
        addFocusListener();
    }

    public RevertingJFormattedTextField(final MaskFormatter format)
    {
        super(format);
        addFocusListener();
    }

    private void addFocusListener()
    {
        addFocusListener(new FocusAdapter()
        {
            @Override
            public void focusGained(final FocusEvent e)
            {
                //Invoke later must be used because, after this is called, the formatter is reset on the field
                //causing the caret to be reset again.
                SwingUtilities.invokeLater(new Runnable()
                {
                    @Override
                    public void run()
                    {
                        selectAll();
                    }
                });
            }
        });
    }

    @Override
    protected void invalidEdit()
    {
        //Recover the most recent value on an invalid edit attempt.
        setValue(getValue());
        super.invalidEdit();
    }
}
