package ohd.hseb.hefs.utils.gui.components;

import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;

import javax.swing.JTextField;
import javax.swing.text.Document;

/**
 * {@link JTextField} subclass will select all when focus is acquired. Otherwise, it is just a standard text field.
 * 
 * @author hank.herr
 */
@SuppressWarnings("serial")
public class SelectAllOnFocusTextField extends JTextField
{

    private void addFocusListener()
    {
        addFocusListener(new FocusAdapter()
        {
            @Override
            public void focusGained(final FocusEvent e)
            {
                selectAll();
            }
        });
    }

    public SelectAllOnFocusTextField()
    {
        super();
        addFocusListener();
    }

    public SelectAllOnFocusTextField(final String text)
    {
        super(text);
        addFocusListener();
    }

    public SelectAllOnFocusTextField(final String text, final int cols)
    {
        super(text, cols);
        addFocusListener();
    }

    public SelectAllOnFocusTextField(final int cols)
    {
        super(cols);
        addFocusListener();
    }

    public SelectAllOnFocusTextField(final Document document, final String text, final int cols)
    {
        super(document, text, cols);
        addFocusListener();
    }
}
