package ohd.hseb.hefs.utils.gui.components;

import java.awt.Component;

import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JSeparator;
import javax.swing.ListCellRenderer;
import javax.swing.border.EmptyBorder;

/**
 * Renderer for a JComboBox in which any string matching SEPARATOR is displayed as a horizontal JSeparator.
 * 
 * @author hank.herr
 */
public class SeparatableJComboBoxRenderer extends JLabel implements ListCellRenderer
{
    private static final long serialVersionUID = 1L;

    private static String SEPARATOR = "--------";

    JSeparator _separator;

    public SeparatableJComboBoxRenderer()
    {
        setOpaque(true);
        setBorder(new EmptyBorder(1, 1, 1, 1));
        _separator = new JSeparator(JSeparator.HORIZONTAL);
    }

    public Component getListCellRendererComponent(JList list,
                                                  Object value,
                                                  int index,
                                                  boolean isSelected,
                                                  boolean cellHasFocus)
    {
        String str = (value == null) ? "" : value.toString();
        if(SEPARATOR.equals(str))
        {
            return _separator;
        }
        if(isSelected)
        {
            setBackground(list.getSelectionBackground());
            setForeground(list.getSelectionForeground());
        }
        else
        {
            setBackground(list.getBackground());
            setForeground(list.getForeground());
        }
        setFont(list.getFont());
        setText(str);
        return this;
    }

    public static boolean isSeparator(Object item)
    {
        if(!(item instanceof String))
        {
            return false;
        }
        return ((String)item).equals(SEPARATOR);
    }

    public static void addSeparator(JComboBox box)
    {
        box.addItem(SEPARATOR);
    }

    /**
     * @return '--------'
     */
    public static String getSeparatorItem()
    {
        return SEPARATOR;
    }
}
