package ohd.hseb.hefs.utils.gui.components;

import static ohd.hseb.hefs.utils.tools.ListTools.addTo;

import java.awt.Color;
import java.awt.Component;
import java.util.List;

import javax.swing.JList;

import ohd.hseb.hefs.utils.SplitCollection;
import ohd.hseb.hefs.utils.collect.CollectionListModel;
import ohd.hseb.hefs.utils.gui.tools.ListCellRendererModifier;

import com.google.common.base.Predicate;

/**
 * A list model which splits its data into two parts based on a supplied {@link Predicate} - elements failing the
 * predicate are placed at the end of the list, grayed out.<br/>
 * <br/>
 * Please use with {@link GenericJList}.
 * 
 * @author alexander.garbarino
 */
public class SplitListModel<E> extends CollectionListModel<E> implements ListCellRendererModifier
{
    public SplitListModel(final SplitCollection<E> delegate, final List<ListCellRendererModifier> modifiers)
    {
        super(delegate, addTo(modifiers, new Modifier<E>(delegate)));
    }

    @Override
    protected SplitCollection<E> delegate()
    {
        return (SplitCollection<E>)super.delegate();
    }

    private static class Modifier<E> implements ListCellRendererModifier
    {
        private final SplitCollection<E> _delegate;

        public Modifier(final SplitCollection<E> delegate)
        {
            _delegate = delegate;
        }

        @Override
        public Component modifyListCellRendererComponent(final Component component,
                                                         final JList list,
                                                         final Object value,
                                                         final int index,
                                                         final boolean isSelected,
                                                         final boolean cellHasFocus)
        {
            if(index >= _delegate.getHeadView().size())
            {
                if(isSelected)
                {
                    component.setForeground(Color.GRAY);
                }
                else
                {
                    component.setForeground(Color.LIGHT_GRAY);
                }
            }
            return component;
        }
    }
}
