package ohd.hseb.hefs.utils.gui.components;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;

import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JSeparator;
import javax.swing.JToolBar;

/**
 * This displays a {@link JToolBar} with components in a panel that is not opaque, thereby allowing mouse events to pass
 * through if not on one of the added components. It has a problem whereby if the user clicks in the toolbar, even if
 * there is no button at that position, the toolbar swallows the event. This means the underlying component does not
 * receive any clicks if the part of hte component is under the toolbar. Call {@link #addToPane(JRootPane)} in order to
 * add this as a glass pane to a {@link JRootPane}.<br>
 * <br>
 * See {@link ComponentPanelGlassPane} for a version of this that does not use a toolbar, but a simple {@link JPanel} with
 * {@link FlowLayout}.
 * 
 * @author hankherr
 */
@SuppressWarnings("serial")
public class ToolBarGlassPane extends JPanel
{
    public static Component SEPARATOR = new JSeparator();

    private final JToolBar _toolBar;

    /**
     * @param toolBarComponents Components to place in tool bar.
     * @param location One of the {@link BorderLayout} constants: NORTH, EAST, SOUTH, WEST.
     */
    public ToolBarGlassPane(final Collection<Component> toolBarComponents, final String borderLayoutLocation)
    {
        _toolBar = new JToolBar();
        for(final Component c: toolBarComponents)
        {
            _toolBar.add(c);
        }
        _toolBar.setFloatable(false);
        _toolBar.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));

        setLayout(new BorderLayout());
        add(_toolBar, borderLayoutLocation);
        setOpaque(false);
        _toolBar.setOpaque(false);

        if((BorderLayout.WEST.equals(borderLayoutLocation)) || (BorderLayout.EAST.equals(borderLayoutLocation)))
        {
            _toolBar.setOrientation(JToolBar.VERTICAL);
        }
    }

    public void addToPane(final JRootPane pane)
    {
        pane.setGlassPane(this);
    }

    public void setToolBarVisible(final boolean b)
    {
        _toolBar.setVisible(b);
    }

    /**
     * This is currently unused (I could never get it to work the way I wanted it to).
     * 
     * @param c
     */
    public void addMouseMotionListenerToMakeToolBarVisible(final Component c)
    {
        final MouseAdapter adapter = new MouseAdapter()
        {
            @Override
            public void mouseEntered(final MouseEvent e)
            {
                setToolBarVisible(true);
            }

            @Override
            public void mouseExited(final MouseEvent e)
            {
                setToolBarVisible(false);
            }
        };

        c.addMouseMotionListener(adapter);
    }
}
