package ohd.hseb.hefs.utils.gui.help;

import static java.awt.KeyboardFocusManager.getCurrentKeyboardFocusManager;

import java.awt.event.ActionEvent;
import java.io.File;

import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.KeyStroke;

/**
 * A help mechanism based on the F1 key.
 * 
 * @author hank.herr
 */
public class CurrentFocusHelpManager extends HelpManager
{
    private final JComponent _topComponent;

    @SuppressWarnings("serial")
    private final Action _displayAction = new AbstractAction()
    {
        @Override
        public void actionPerformed(ActionEvent e)
        {
            getDisplayHelpEffect().perform(getCurrentKeyboardFocusManager().getFocusOwner());
        }
    };

    public CurrentFocusHelpManager(File helpDirectory, JComponent topComponent)
    {
        super(helpDirectory);
        _topComponent = topComponent;

        KeyStroke keyStroke = KeyStroke.getKeyStroke("F1");
        String actionName = this.toString();
        _topComponent.getInputMap(JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT).put(keyStroke, actionName);
        _topComponent.getActionMap().put(actionName, _displayAction);
    }
}
