package ohd.hseb.hefs.utils.gui.help;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * This defines an annotation that looks like "@HelpFile([filename])". It defines a help file or URL for something that
 * uses the {@link HelpManager} structure interface. Specify it as follows:<br>
 * <br>
 * 1. If the help file is an PDF, it should start with {@value HelpManager#PDF_HELP_PREFIX}. In that case, a '#' can be
 * included after the name of the pdf file and what is after will be treated as a page number if it is a number, or a
 * bookmark/title in the pdf file otherwise. If the PDF file name does not start with 'jar:', 'http:', or 'file:', then
 * it is assumed to be specified relative to a directory provided to the constructor to {@link HelpManager} if not null
 * or as a complete path otherwise. If the pdf file is not prefixed by {@value HelpManager#PDF_HELP_PREFIX}, then it
 * will be opened via a browser as specified in items 2, 3, or 4, below. <br>
 * 2. If the help file is an internet URL, then specify the complete link in the annotation. Example
 * http://www.example.com/testFile.html#bookmark<br>
 * 3. If the help file is on the file system in an absolution location, refer to it in a URL that starts with 'file:'.
 * For example, "file:/home/user/exampleHelp.htm#bookmark1"<br>
 * 4. If the help file is on the file system under a standard directory to be provided to {@link HelpManager}, then just
 * specify the file name, optionally followed by '#' with a bookmark. Example: "helpFile.htm#bookmark1" A 'file:' URL
 * will be constructed based on the file name and the directory contained in HelpManager. This makes it so that the help
 * file location need not be known by the application by can be located via relative path to something specified
 * dynamically.<br>
 * 
 * @author hank.herr
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.TYPE)
public @interface HelpFile
{
    String value();
}
