package ohd.hseb.hefs.utils.gui.jtable;

import java.awt.Component;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;

/**
 * This was pulled from http://www.coderanch.com/t/343795/GUI/java/Check-Box-JTable-header and displays a checkbox in
 * the header for a table column.
 * 
 * @author hank.herr
 */
public class CheckboxColumnHeader extends JCheckBox implements TableCellRenderer, MouseListener
{
    private static final long serialVersionUID = 1L;
    protected int _column;
    protected boolean _mousePressed = false;

    public CheckboxColumnHeader(String text, ItemListener itemListener)
    {
        setText(text);
        addItemListener(itemListener);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table,
                                                   Object value,
                                                   boolean isSelected,
                                                   boolean hasFocus,
                                                   int row,
                                                   int column)
    {
        if(table != null)
        {
            JTableHeader header = table.getTableHeader();
            if(header != null)
            {
                setForeground(header.getForeground());
                setBackground(header.getBackground());
                setFont(header.getFont());
                header.addMouseListener(this);
            }
        }
        setColumn(column);
        setBorder(UIManager.getBorder("TableHeader.cellBorder"));
        return this;
    }

    protected void setColumn(int column)
    {
        this._column = column;
    }

    public int getColumn()
    {
        return _column;
    }

    protected void handleClickEvent(MouseEvent e)
    {
        if(_mousePressed)
        {
            _mousePressed = false;
            JTableHeader header = (JTableHeader)(e.getSource());
            JTable tableView = header.getTable();
            TableColumnModel columnModel = tableView.getColumnModel();
            int viewColumn = columnModel.getColumnIndexAtX(e.getX());
            int column = tableView.convertColumnIndexToModel(viewColumn);

            if(viewColumn == this._column && e.getClickCount() == 1 && column != -1)
            {
                doClick();
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e)
    {
        handleClickEvent(e);
        ((JTableHeader)e.getSource()).repaint();
    }

    @Override
    public void mousePressed(MouseEvent e)
    {
        _mousePressed = true;
    }

    @Override
    public void mouseReleased(MouseEvent e)
    {
    }

    @Override
    public void mouseEntered(MouseEvent e)
    {
    }

    @Override
    public void mouseExited(MouseEvent e)
    {
    }
}
