package ohd.hseb.hefs.utils.gui.jtable;

import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.util.HashMap;
import java.util.Map;

import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

/**
 * Displays tools tips for column headers. Add an instance of this as a {@link MouseMotionListener} to the
 * {@link JTable#getTableHeader()}; or call {@link #addToTable(JTable)} which does this for you. Set the tool tips via
 * the {@link #setToolTip(TableColumn, String)} method. If not given and if {@link #_defaultToDisplayFullHeaderText} is
 * true (it defaults to false), the tool tip displayed will be the header value reprinted in full, which is useful if
 * the columns are narrower than the header. This code is copied from the internet somewhere (can't remeber where).
 * 
 * @author hank.herr
 */
public class ColumnHeaderToolTips extends MouseMotionAdapter
{
    /**
     * Current column whose tooltip is being displayed. This variable is used to minimize the calls to setToolTipText().
     */
    private TableColumn _curCol;

    /**
     * Maps tool tip to column.
     */
    private final Map<TableColumn, String> _tips = new HashMap<TableColumn, String>();

    /**
     * If true, then if no tip is set via {@link #setToolTip(TableColumn, String)}, it will default to redisplaying the
     * column name as given in {@link TableColumn#getHeaderValue()}. The header value must be a {@link String}.
     */
    private boolean _defaultToDisplayFullHeaderText = false;

    public ColumnHeaderToolTips()
    {
        super();
    }

    public ColumnHeaderToolTips(final boolean defaultToDisplayFullHeaderText)
    {
        super();
        _defaultToDisplayFullHeaderText = defaultToDisplayFullHeaderText;
    }

    /**
     * Example call: new ColumnHeaderToolTips().addToTable(_table);
     * 
     * @param table The table to which to add column header tool tips.
     */
    public void addToTable(final JTable table)
    {
        table.getTableHeader().addMouseMotionListener(this);
    }

    /**
     * @param col The column for which to assign a tool tip.
     * @param tooltip The tool tip to assign. If tooltip is null, removes any tooltip text.
     */
    public void setToolTip(final TableColumn col, final String tooltip)
    {
        if(tooltip == null)
        {
            _tips.remove(col);
        }
        else
        {
            _tips.put(col, tooltip);
        }
    }

    public void setDefaultToDisplayFullHeaderText(final boolean defaultToDisplayFullHeaderText)
    {
        _defaultToDisplayFullHeaderText = defaultToDisplayFullHeaderText;
    }

    @Override
    public void mouseMoved(final MouseEvent evt)
    {
        TableColumn col = null;
        final JTableHeader header = (JTableHeader)evt.getSource();
        final JTable table = header.getTable();
        final TableColumnModel colModel = table.getColumnModel();
        final int vColIndex = colModel.getColumnIndexAtX(evt.getX());
        // Return if not clicked on any column header 
        if(vColIndex >= 0)
        {
            col = colModel.getColumn(vColIndex);
        }

        if(col != _curCol)
        {
            String tip = _tips.get(col);

            //Get the default value if desired.
            if((tip == null) && (_defaultToDisplayFullHeaderText) && (col != null))
            {
                final Object colHeaderValue = col.getHeaderValue();
                if(colHeaderValue instanceof String)
                {
                    tip = (String)colHeaderValue;
                }
            }

            header.setToolTipText(tip);
            _curCol = col;
        }
    }

}
