package ohd.hseb.hefs.utils.gui.jtable;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

/**
 * Copied from internet, but I failed to mark the page... google it!<br>
 * <br>
 * Add this as a mouse listener to a component in a {@link JScrollPane}, and draggins will allow for panning around the
 * component.
 * 
 * @author hankherr
 */
public class DragScrollHandler extends MouseAdapter
{

    private final JComponent _component;
    private Point _pressed, _here;
    private Rectangle _visiRect;

    public DragScrollHandler(final JComponent component)
    {
        this._component = component;
        component.addMouseListener(this);
        component.addMouseMotionListener(this);
    }

    public static void createDragScrollHandlerFor(final JComponent component)
    {
        new DragScrollHandler(component);
    }

    public void dispose()
    {
        _component.removeMouseListener(this);
        _component.removeMouseMotionListener(this);
    }

    @Override
    public void mousePressed(final MouseEvent e)
    {
        _pressed = e.getPoint();
        _visiRect = _component.getVisibleRect();
    }

    @Override
    public void mouseDragged(final MouseEvent e)
    {
        if((_component == null) && (_pressed == null) || (_visiRect == null))
        {
            return;
        }

        _here = e.getPoint();
        _visiRect.x += (_pressed.x - _here.x);
        _visiRect.y += (_pressed.y - _here.y);
        _component.scrollRectToVisible(_visiRect);
        SwingUtilities.invokeLater(new Runnable()
        {
            public void run()
            {
                final Rectangle newRect = _component.getVisibleRect();
                _pressed.x += newRect.x - _visiRect.x;
                _pressed.y += newRect.y - _visiRect.y;
                _visiRect = newRect;
            }
        });
    }
}
