package ohd.hseb.hefs.utils.gui.jtable;

import java.util.List;

import ohd.hseb.hefs.utils.gui.jtable.models.GetRowTableModel;
import ohd.hseb.hefs.utils.notify.Notice;

import com.google.common.eventbus.Subscribe;

/**
 * Posted by {@link GenericTable} whenever a row is selected, it specifies the model row indices, a total table row
 * count, and a general {@link List} of row objects selected, if the underlying model implements
 * {@link GetRowTableModel}.
 * 
 * @author Hank.Herr
 */
public class GeneralRowSelectionNotice extends Notice
{

    private final int[] _selectedModelRowIndices;
    private final List _selectedRows;
    private final int _totalRowCount;

    /**
     * A clear marks notice.
     * 
     * @param source
     * @param clearRowMarks Row marks will be cleared if true. If false, column marks are cleared.
     */
    public GeneralRowSelectionNotice(final Object source,
                                     final int[] selectedModelRowIndices,
                                     final List selectedRows,
                                     final int totalRowCount)
    {
        super(source);
        _selectedModelRowIndices = selectedModelRowIndices;
        _selectedRows = selectedRows;
        _totalRowCount = totalRowCount;
    }

    public int[] getSelectedModelRowIndices()
    {
        return _selectedModelRowIndices;
    }

    public List getSelectedRows()
    {
        return _selectedRows;
    }

    public int getTotalRowCount()
    {
        return _totalRowCount;
    }

    public static interface Subscriber
    {
        @Subscribe
        public void reactToTableRowSelection(GeneralRowSelectionNotice evt);
    }
}
