package ohd.hseb.hefs.utils.gui.jtable;

import java.awt.Component;

import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.SortOrder;
import javax.swing.SwingConstants;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;

import sun.swing.DefaultLookup;
import sun.swing.table.DefaultTableCellHeaderRenderer;

/**
 * This header renderer is a {@link JLabel} that uses {@link UIManager} to get the table header foreground, background,
 * cell border, and font. The hor/vert alignment is bottom left. This renderer wraps the column names.<br>
 * <br>
 * This renderer was created because the default one does not handle multiline (using html tags) column names properly.
 * It would show on multiple lines but if the label width exceeded the column width, a double image was created. This,
 * instead, wraps the label to the column width.<br>
 * <br>
 * This header renderer is made public so that it can be used outside of {@link GenericTable} if necessary.
 * 
 * @author hankherr
 */
@SuppressWarnings("serial")
public class GenericTableHeaderRenderer extends JLabel implements TableCellRenderer
{

    public GenericTableHeaderRenderer()
    {
        setOpaque(false);
        setForeground(UIManager.getColor("TableHeader.foreground"));
        setBackground(UIManager.getColor("TableHeader.background"));
        setBorder(UIManager.getBorder("TableHeader.cellBorder"));
        setFont(UIManager.getFont("TableHeader.font"));
        setHorizontalAlignment(SwingConstants.LEFT);
        setVerticalAlignment(SwingConstants.BOTTOM);
    }

    @Override
    public Component getTableCellRendererComponent(final JTable table,
                                                   final Object value,
                                                   final boolean isSelected,
                                                   final boolean hasFocus,
                                                   final int row,
                                                   final int column)
    {
        //This code was pulled directly from DefaultTableCellHeaderRenderer source found through Google.
        Icon sortIcon = null;
        if(table.getRowSorter() != null)
        {
            final SortOrder sortOrder = DefaultTableCellHeaderRenderer.getColumnSortOrder(table, column);
            if(sortOrder != null)
            {
                switch(sortOrder)
                {
                    case ASCENDING:
                        sortIcon = DefaultLookup.getIcon(this, ui, "Table.ascendingSortIcon");
                        break;
                    case DESCENDING:
                        sortIcon = DefaultLookup.getIcon(this, ui, "Table.descendingSortIcon");
                        break;
                    case UNSORTED:
                        sortIcon = DefaultLookup.getIcon(this, ui, "Table.naturalSortIcon");
                        break;
                }
            }
        }

        this.setText((String)value);
        this.setIcon(sortIcon);
        return this;
    }

}
