package ohd.hseb.hefs.utils.gui.jtable;

import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

import org.jdesktop.swingx.JXTable;

/**
 * This is made necessary due to issues with existing {@link JTable} and {@link JXTable}. This is a listener that
 * receives specific events related to a {@link GenericTable}.
 * 
 * @author hankherr
 */
public interface GenericTableListener
{

    /**
     * This is called after the {@link GenericTable} is updated due to a change in the underlying {@link TableModel}. In
     * otherwords, this is called at the end of the {@link GenericTable#tableChanged(javax.swing.event.TableModelEvent)}
     * method. It is useful if you need to react to a change in the {@link TableModel}, but must be sure to react AFTER
     * the {@link GenericTable}'s structure has been updated. Note that you cannot use a standard
     * {@link TableModelListener} for that purpose, because the {@link TableModelListener} are processed in reverse
     * order when a {@link TableModelEvent} is fired by the {@link TableModel}, so that the table's structure may not
     * have been updated when your listener is called.
     * 
     * @param e The original event that caused the table to be updated.
     */
    public void tableUpdatedDueToModelChange(TableModelEvent e);

}
