package ohd.hseb.hefs.utils.gui.jtable;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;

import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.ScrollPaneConstants;

import ohd.hseb.hefs.utils.gui.jtable.buttons.RefreshButton;
import ohd.hseb.hefs.utils.gui.jtable.buttons.SelectAllButton;
import ohd.hseb.hefs.utils.gui.jtable.buttons.UnselectAllButton;
import ohd.hseb.hefs.utils.gui.tools.HSwingFactory;

/**
 * A general panel that wraps a {@link GenericTable} instance, displaying it with a toolbar below that can include
 * buttons specified in the constructor. Constants are provided for standard toolbar components, such as a select all
 * button, clear selection button, and separator.
 * 
 * @author hank.herr
 */
@SuppressWarnings("serial")
public class GenericTablePanel extends JPanel
{
    /**
     * Adds a select all button, unselect button, and a separator.
     */
    public static final Component DEFAULT_BUTTONS_LEFT = new ComponentMarker();

    public static final Component DEFAULT_BUTTONS = new ComponentMarker();
    public static final Component REFRESH_BUTTON = new ComponentMarker();
    public static final Component SELECT_ALL_BUTTON = new ComponentMarker();
    public static final Component UNSELECT_BUTTON = new ComponentMarker();
    public static final Component FILLER = new ComponentMarker();
    public static final Component SEPARATOR = new ComponentMarker();

    private static class ComponentMarker extends Component
    {
    }

    private final GenericTable _table;
    private final JScrollPane _tableScrollPane;

    public GenericTable getTable()
    {
        return _table;
    }

    /**
     * This will {@link GenericTable#setAutoCreateRowSorter(boolean)} upon being called, which recreates the row sorter!
     * 
     * @param table The table to wrap.
     * @param toolBarComponents The tool bar components, or an empty list for no tool bar.See the constants defined in
     *            this class for some default components that can be provided.
     * @param borderTitle The title on the border, or null for no title.
     */
    public GenericTablePanel(final GenericTable table, final List<Component> toolBarComponents, final String borderTitle)
    {
        _table = table;

        this.setLayout(new BorderLayout());

        // Table Panel
        _tableScrollPane = new JScrollPane(_table);
        if(borderTitle != null)
        {
            _tableScrollPane.setBorder(HSwingFactory.createTitledBorder(BorderFactory.createEtchedBorder(1),
                                                                        borderTitle,
                                                                        null));
        }
        _tableScrollPane.setViewportView(_table);
        _tableScrollPane.setVerticalScrollBarPolicy(ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS);

        setLayout(new BorderLayout());
        add(_tableScrollPane, BorderLayout.CENTER);

        processToolBarComponents(toolBarComponents);
    }

    private void processToolBarComponents(final List<Component> toolBarComponents)
    {
        // Lower components panel
        if((toolBarComponents != null) && (!toolBarComponents.isEmpty()))
        {
            final JToolBar toolBar = new JToolBar();
            toolBar.setFloatable(false);

            for(int i = 0; i < toolBarComponents.size(); i++)
            {
                final Component comp = toolBarComponents.get(i);

                // One of the table's default components.
                if(comp instanceof ComponentMarker)
                {
                    if(comp == SELECT_ALL_BUTTON || comp == DEFAULT_BUTTONS || comp == DEFAULT_BUTTONS_LEFT)
                    {
                        toolBar.add(new SelectAllButton(_table));
                    }
                    if(comp == UNSELECT_BUTTON || comp == DEFAULT_BUTTONS || comp == DEFAULT_BUTTONS_LEFT)
                    {
                        toolBar.add(new UnselectAllButton(_table));
                    }
                    if(comp == SEPARATOR || comp == DEFAULT_BUTTONS || comp == DEFAULT_BUTTONS_LEFT)
                    {
                        //Only add a separator if there are two items to separate!
                        if((i < toolBarComponents.size() - 1) && (toolBarComponents.get(i + 1) != FILLER))
                        {
                            toolBar.addSeparator();
                        }
                    }
                    if(comp == FILLER || comp == DEFAULT_BUTTONS)
                    {
                        toolBar.add(HSwingFactory.createFillerJPanel());
                    }
                    if(comp == REFRESH_BUTTON || comp == DEFAULT_BUTTONS)
                    {
                        toolBar.add(new RefreshButton(_table));
                    }
                }
                // Custom component.
                else
                {
                    toolBar.add(comp);
                }
            }

            add(toolBar, BorderLayout.SOUTH);
        }
    }
}
