package ohd.hseb.hefs.utils.gui.jtable;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

import javax.swing.JLabel;
import javax.swing.JTable;

/**
 * Add an instance of this as a MouseListener to a JTable. It will detect clicks of a delete column (see the
 * TableUtilities) and call the JTableDeleteProcessor's processDeleteAction method if clicked.
 * 
 * @author hank.herr
 */
public class JTableAddDeleteMouseListener extends MouseAdapter
{

    private final JTable _table;
    private final JTableDeleteProcessor _deleteProcessor;
    private final JTableAddProcessor _addProcessor;

    public JTableAddDeleteMouseListener(JTable table, JTableDeleteProcessor mgrPanel)
    {
        super();
        this._table = table;
        this._deleteProcessor = mgrPanel;
        this._addProcessor = null;
    }

    public JTableAddDeleteMouseListener(JTable table, JTableAddProcessor mgrPanel)
    {
        super();
        this._table = table;
        this._deleteProcessor = null;
        this._addProcessor = mgrPanel;
    }

    public JTableAddDeleteMouseListener(JTable table, JTableDeleteProcessor delProc, JTableAddProcessor addProc)
    {
        super();
        this._table = table;
        this._deleteProcessor = delProc;
        this._addProcessor = addProc;
    }

    @Override
    public void mousePressed(MouseEvent evt)
    {
        int column = _table.columnAtPoint(evt.getPoint());
        int row = _table.rowAtPoint(evt.getPoint());

        if(row < 0 || row >= _table.getRowCount() || column < 0 || column >= _table.getColumnCount())
        {
            return;
        }

        Object value;
        value = _table.getValueAt(row, column);

        if(value instanceof JLabel)
        {
            if(TableTools.isJLabelADeleteLabel((JLabel)value))
            {
                _deleteProcessor.processDeleteAction(evt.getSource(), row);
            }
            if(TableTools.isJLabelAnAddLabel((JLabel)value))
            {
                _addProcessor.processAddAction(evt.getSource(), row);
            }
        }

    }
}