package ohd.hseb.hefs.utils.gui.jtable;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;

import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.filechooser.FileFilter;

import ohd.hseb.hefs.utils.filechooser.FileExtensionFileFilter;
import ohd.hseb.hefs.utils.filechooser.HGlobalFileChooser;

import com.google.common.collect.Lists;

/**
 * General purpose menu item for dumping the contents of a table to a CSV file. It opens up a file chooser through
 * {@link HGlobalFileChooser} so that the chooser remembers the previous directory.
 * 
 * @author Hank.Herr
 */
@SuppressWarnings("serial")
public class OutputDataToCSVFileMenuItem extends JMenuItem
{

    public OutputDataToCSVFileMenuItem(final JTable baseTable, final Component dialogParentComponent)
    {
        super("Output Data to CSV File...");
        addActionListener(new ActionListener()
        {

            @Override
            public void actionPerformed(final ActionEvent e)
            {
                final HGlobalFileChooser chooser = HGlobalFileChooser.getFileChooser("Specify CSV File Name",
                                                                                     "tableDataSaveChooser",
                                                                                     Lists.newArrayList(((FileFilter)new FileExtensionFileFilter("csv",
                                                                                                                                                 "CSV file"))));
                File toSave = chooser.saveFile(dialogParentComponent);
                if(toSave == null)
                {
                    return;
                }
                if(!toSave.getName().endsWith(".csv"))
                {
                    toSave = new File(toSave.getAbsolutePath() + ".csv");
                }
                try
                {
                    TableTools.dumpTableToFile(baseTable, toSave, ",");
                }
                catch(final Throwable t)
                {
                    JOptionPane.showMessageDialog(dialogParentComponent,
                                                  t.getMessage(),
                                                  "Error output data to file!",
                                                  JOptionPane.ERROR_MESSAGE);
                }
            }
        });
    }
}
