package ohd.hseb.hefs.utils.gui.jtable;

import java.awt.Graphics;

import javax.swing.JTable;
import javax.swing.table.TableModel;

/**
 * Useful in multithreading. This class will pause any Swing paint attempt until the _waitToPaint flag is false. This
 * can prevent multithreading errors that may occur if the swing-drawing thread attempts to paint this table while
 * another thread is changing the table model or other aspect of the table.
 * 
 * @author herrhd
 */
public class PaintPreventableJTable extends JTable
{
    private static final long serialVersionUID = 1L;

    private boolean _waitToPaint = false;

    private boolean _currentlyPainting = false;

    public synchronized void setWaitToPaint(boolean b)
    {
        this._waitToPaint = b;
    }

    public boolean getCurrentlyPainting()
    {
        return this._currentlyPainting;
    }

    public PaintPreventableJTable(TableModel model)
    {
        super(model);
    }

    @Override
    public void paintComponent(Graphics g)
    {
        while(_waitToPaint)
        {
            try
            {
                Thread.sleep(1);
            }
            catch(InterruptedException e)
            {
            }
        }
        _currentlyPainting = true;
        super.paintComponent(g);
        _currentlyPainting = false;
    }
}
