package ohd.hseb.hefs.utils.gui.jtable;

import ohd.hseb.hefs.utils.notify.Notice;

import com.google.common.eventbus.Subscribe;

/**
 * Post to a bus with a {@link MarkedTableScrollPanel} registered to it in order to indicate that the marks need to be
 * recomputed. When to post these events is table model specific.
 * 
 * @author hankherr
 */
public class RecomputeMarksNotice extends Notice
{
    /**
     * A clear marks notice.
     * 
     * @param source
     * @param clearRowMarks Row marks will be cleared if true. If false, column marks are cleared.
     */
    public RecomputeMarksNotice(final Object source)
    {
        super(source);
    }

    public static interface Subscriber
    {
        @Subscribe
        public void reactToRecomputMarks(RecomputeMarksNotice evt);
    }

}
