package ohd.hseb.hefs.utils.gui.jtable.buttons;

import java.awt.event.ActionEvent;

import javax.swing.JOptionPane;

import ohd.hseb.hefs.utils.gui.jtable.GenericTable;
import ohd.hseb.hefs.utils.gui.jtable.TableTools;
import ohd.hseb.hefs.utils.gui.jtable.models.AddDeleteRowTableModel;
import ohd.hseb.hefs.utils.gui.tools.MultiItemButton;

/**
 * This button uses a {@link GenericTable} and an {@link AddDeleteRowTableModel}. It is a {@link MultiItemButton} that
 * is active only when one or more rows are selected in GenericTable. When clicked, it calls the method
 * {@link AddDeleteRowTableModel#deleteRow(int, int[])} passing -1 as the first argument and all of the selected rows
 * converted to the model as the second argument via
 * {@link TableTools#getSelectedRowsConvertedToModel(javax.swing.JTable)}.
 * 
 * @author hank.herr
 */
@SuppressWarnings("serial")
public class DeleteSelectedRowsButton extends MultiItemButton
{
    private final AddDeleteRowTableModel _tableModel;
    private final GenericTable _table;

    /**
     * @param table The table which provides the selected rows.
     * @param tableModel The table model whose deleteRow will be called, passing in -1 and all selected rows.
     */
    public DeleteSelectedRowsButton(final GenericTable table, final AddDeleteRowTableModel tableModel)
    {
        super("selectedRowDelete20x20", "Delete Selected Rows");
        _table = table;
        _table.getRowSelectionBus().register(this);
        _tableModel = tableModel;
    }

    @Override
    public void actionPerformed(final ActionEvent e)
    {
        final int option = JOptionPane.showConfirmDialog(_table.getParent(),
                                                         "All selected rows will be deleted.  Continue?",
                                                         "Confirm Delete",
                                                         JOptionPane.YES_NO_OPTION);
        if(option == JOptionPane.YES_OPTION)
        {
            _tableModel.deleteRow(-1, TableTools.getSelectedRowsConvertedToModel(_table));
        }
    }
}
