package ohd.hseb.hefs.utils.gui.jtable.buttons;

import java.awt.event.ActionEvent;
import java.util.List;

import javax.swing.JTable;
import javax.swing.table.TableModel;

import ohd.hseb.hefs.utils.status.StatusIndicator;

import com.google.common.collect.Lists;

/**
 * Attaches itself to all columns that return a type of {@link StatusIndicator}. Will select all rows where any status
 * indicator is not true, but it only checks status indicators for which
 * {@link StatusIndicator#includeInRowReadinessCheck()} returns true.
 * 
 * @author Hank.Herr
 */
@SuppressWarnings("serial")
public class SelectUnreadyRowsButton extends JTableButton
{
    public SelectUnreadyRowsButton(JTable table)
    {
        super(table, "selectErrorWarningRows20x20", "Select Rows That Need Processing");
    }

    @Override
    public void actionPerformed(ActionEvent e)
    {
        _table.getSelectionModel().setValueIsAdjusting(true);

        _table.clearSelection();

        List<Integer> columnsToCheck = getStatusIndicatorColumns();

        for(int i = 0; i < _table.getModel().getRowCount(); i++)
        {
            if(!rowIsToBeSelected(i, columnsToCheck))
            {
                _table.getSelectionModel().addSelectionInterval(i, i);
            }
        }

        _table.getSelectionModel().setValueIsAdjusting(false);
    }

    /**
     * @return all columns which house a {@link StatusIndicator}.
     */
    private List<Integer> getStatusIndicatorColumns()
    {
        List<Integer> columns = Lists.newArrayList();

        TableModel model = _table.getModel();
        for(int i = 0; i < model.getColumnCount(); i++)
        {
            if(StatusIndicator.class.isAssignableFrom(model.getColumnClass(i)))
            {
                columns.add(i);
            }
        }
        return columns;
    }

    /**
     * @return True if the row should be selected; i.e., it is not ready.
     */
    private boolean rowIsToBeSelected(int row, List<Integer> columns)
    {
        for(Integer column: columns)
        {
            if(((StatusIndicator)_table.getModel().getValueAt(row, column)).includeInRowReadinessCheck()
                && !((StatusIndicator)_table.getModel().getValueAt(row, column)).isReady())
            {
                return false;
            }
        }
        return true;
    }
}
