package ohd.hseb.hefs.utils.gui.jtable.models;

import javax.swing.JTable;
import javax.swing.table.TableModel;

/**
 * This table supports the addition and deletion of rows.
 * 
 * @author alexander.garbarino
 */
public interface AddDeleteRowTableModel extends TableModel
{
    /**
     * Adds a new row to the end of the table.
     */
    public void addRow();

    /**
     * Deletes the row(s) with the given index.
     * 
     * @param indexOfRowClicked The index of the row clicked for deletion.
     * @param allTableSelectedIndices The indices of all selected rows, in case all selected rows will be deleted. Row
     *            indices are according to the view and may need to be converted via
     *            {@link JTable#convertRowIndexToModel(int)}.
     */
    public void deleteRow(int indexOfRowClicked, int[] allTableSelectedIndices);
}
