package ohd.hseb.hefs.utils.gui.jtable.models;

import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

import ohd.hseb.hefs.utils.gui.jtable.GenericTable;
import ohd.hseb.hefs.utils.gui.jtable.GenericTableHeaderRenderer;

/**
 * Implement if the table must be displayed with custom header renderers. See {@link GenericTableHeaderRenderer} for an
 * example of a renderer you can return.
 * 
 * @author hankherr
 */
public interface ColumnHeaderRendererTableModel extends TableModel
{
    /**
     * @param modelColumn The model column index for which a renderer must be craeted.
     * @return A {@link TableCellRenderer} for use in renderering the column headers for a table displaying the model.
     *         If null is returned the default {@link GenericTableHeaderRenderer} will be used by {@link GenericTable}.
     */
    public TableCellRenderer getColumnHeaderRenderer(int modelColumn);
}
